<?php

require_once('../config.php');

if ($connect->connect_error)
    die('Connect Error (' . $connect->connect_errno . ') ' . $connect->connect_error);

$connect->query("SET SESSION collation_connection = 'utf8_persian_ci';");

$connect->query("CREATE TABLE if not exists `user` (
    `id` bigint PRIMARY KEY,
    `step` text NOT NULL
    ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

$connect->query("CREATE TABLE if not exists `step` (
    `id` bigint NOT NULL,
    `step` text NOT NULL,
    `data` text COLLATE utf8mb4_persian_ci NOT NULL,
    `inserttime` bigint DEFAULT 0
    ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

$connect->query("CREATE TABLE if not exists `settings` (
    `cookie` varchar(700) DEFAULT NULL,
    `lastlogin` bigint DEFAULT 0,
    `lastCheck` bigint DEFAULT 0
    ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

$connect->query("CREATE TABLE if not exists `records` (
    `ip` varchar(50) NOT NULL,
    `node_id` int NOT NULL,
    `zone_id` varchar(300) NOT NULL,
    `record_id` varchar(300) DEFAULT NULL,
    `domain` varchar(120) NOT NULL,
    `ttl` int DEFAULT 1,
    `last_check` bigint DEFAULT 0,
    `is_online` boolean DEFAULT true,
    `inserttime` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    UNIQUE KEY `unique_domain_ip` (`domain`, `ip`)
    ) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;");

if ($connect->query('SELECT * FROM `settings`;')->num_rows == 0) {
    $connect->query("INSERT INTO `settings` () VALUES ();");
    openLink(BOT_ADDRESS . 'bot.php');
    openLink(BOT_ADDRESS . 'plugins/login.php');
    echo '<h1 align="center"><b>راه اندازی ربات با موفقیت انجام شد.</b></h1>';
}
function openLink($url)
{
    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => $url,
        CURLOPT_TIMEOUT => 10
    ));
    return curl_exec($ch);
}
$connect->close();
echo '<h1 align="center"><b>دیتابیس متصل و نصب شد .</b></h1>';
?>