<?php

class Marzban
{
    private $url;
    private $username;
    private $password;

    /**
     * Constructor: __construct
     * Enter the required parameters in the call of the class. 
     * You can also create a variable named marzban_config as an array, without calling the parameters and put the required items in it.
     */

    public function __construct(
        $url = null,
        $username = null,
        $password = null
    ) {
        global $marzban_config;
        $this->url =        $url        ?: $marzban_config['url'];
        $this->username =   $username   ?: $marzban_config['username'];
        $this->password =   $password   ?: $marzban_config['password'];
    }

    /**
     * Login to the panel
     * access_token will be save in session_file
     * Notic: set a special access token on the file.
     */

    public function login()
    {
        global $connect;
        $time =             time();
        $result =           false;
        $content = [
            'username' =>   $this->username,
            'password' =>   $this->password,
            'grant_type' => 'password',
        ];
        $req =              $this->Request('api/admin/token', $content, 'POST', false);
        @$access_token =    $req['access_token'];
        if (! is_null($access_token)) {
            $connect->query("UPDATE `settings` SET `cookie` = '$access_token', `lastlogin` = $time;");
            $result =       true;
        }
        return $result;
    }

    /**
     * get Panel status
     */

    public function status()
    {
        return $this->Request('api/system', [], 'GET');
    }

    /**
     * restart Core
     */

    public function coreRestart()
    {
        return $this->Request('api/core/restart', [], 'POST', true, true);
    }



    /**
     * get Clients list
     * limit 0 = all Clients
     */

    public function list(
        $limit = 0,
        $offset = 0,
        $sort = '-created_at'
    ) {
        if ($limit == 0)
            $arpar = array(
                'sort' =>   $sort
            );
        else {
            $arpar = array(
                'limit' =>  $limit,
                'offset' => $offset,
                'sort' =>   $sort
            );
        }
        $params =   http_build_query($arpar);
        return $this->Request('api/users?' . $params, [], 'GET');
    }

    /**
     * get nodes usage
     */
    public function nodes_usage(
        $start_date = null,
        $end_date = null
    ) {
        $params = null;
        if (!empty($start_date)) {
            $params = ['start' => $start_date];
            if (!empty($end_date)) {
                $params = ['start' => $start_date, 'end' => $end_date];
            }
            $params = '?' . http_build_query($params);
        }
        return $this->Request('api/nodes/usage' . $params, [], 'GET');
    }

    public function node_reconnect(
        int $node_id
    ) {
        $result =       false;
        $Req =          $this->Request('api/node/' . $node_id . '/reconnect', [], 'POST', true, true);
        if ($Req == 200)
            $result =   true;
        return $result;
    }

    public function node_quick_update(
        string $ip,
        string $name,
        string $content
    ) {
        $nodes =        $this->Request('api/nodes', [], 'GET');
        foreach ($nodes as $check) {
            if ($check['address'] == $ip)
                $node = $check;
        }
        $node[$name] = $content;
        $result = $this->node_update($node);
        return $result;
    }

    public function node_update(
        array $data
    ) {
        $result =       false;
        $Req =          $this->Request('api/node/' . $data['id'], json_encode($data), 'PUT', true, true);
        if ($Req == 200)
            $result =   true;
        return $result;
    }

    /**
     * get nodes servers
     */

    public function nodes()
    {
        return $this->Request('api/nodes', [], 'GET');
    }

    /**
     * get core status
     */

    public function core_status()
    {
        return $this->Request('api/core', [], 'GET');
    }

    /**
     * get core config
     */

    public function core_config()
    {
        return $this->Request('api/core/config', [], 'GET');
    }

    /**
     * get hosts
     */

    public function hosts()
    {
        return $this->Request('api/hosts', [], 'GET');
    }

    /**
     * get inbounds
     */

    public function inbounds()
    {
        return $this->Request('api/inbounds', [], 'GET');
    }

    /**
     * check access_key ( session_file )
     */

    public function admin()
    {
        return $this->Request('api/admin', [], 'GET');
    }

    /**
     * check client node usage
     */

    public function client_nodeusage(
        string $username,
        $start_date = null,
        $end_date = null
    ) {
        $params = null;
        if (!empty($start_date)) {
            $params = ['start' => $start_date];
            if (!empty($end_date)) {
                $params = ['start' => $start_date, 'end' => $end_date];
            }
            $params = '?' . http_build_query($params);
        }
        return $this->Request('api/user/' . $username . '/usage' . $params, [], 'GET');
    }

    /**
     * get complete info of client
     */

    public function info(
        $username
    ) {
        return $this->Request('api/user/' . $username, [], 'GET');
    }

    /**
     * reset client usage
     */

    public function resetUsage(
        $username
    ) {
        $req =          $this->Request('api/user/' . $username . '/reset', [], 'POST', true, true);
        $result =       ($req == 200) ? true : false;
        return $result;
    }

    /**
     * delete client
     */

    public function delete(
        $username
    ) {
        $result =       false;
        $req =          $this->Request('api/user/' . $username, [], 'DELETE', true, true);

        if ($req == 200 || $req == 404)
            $result =   true;

        return $result;
    }

    public function full_status()
    {
        return $this->Request('api/system', [], 'GET');
    }

    /**
     * generate uid
     */

    public function genuid()
    {
        $data = random_bytes(16);
        assert(strlen($data) == 16);
        $data[6] = chr(ord($data[6]) & 0x0f | 0x40);
        $data[8] = chr(ord($data[8]) & 0x3f | 0x80);
        return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }

    /**
     * sender of the request to the Marzban Panel
     */

    public function Request(
        $action,
        $content,
        $method = 'POST',
        bool $json_input = true,
        bool $http_code = false
    ) {
        global $connect;
        @$settings =        $connect->query("SELECT * FROM `settings`")->fetch_assoc();
        $headers = array(
            'Cookie: i18next=en-US',
            'Accept: application/json',
            'Authorization: Bearer ' . $settings['cookie'],
            'User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36',
            'Content-Type: application/json'
        );
        if (!$json_input)
            array_pop($headers);

        $ch = curl_init($this->url . '/' . $action);

        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $method);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $content);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_TIMEOUT, 35);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result =       curl_exec($ch);

        if (curl_error($ch))
            var_dump(curl_error($ch));

        if ($http_code == true)
            $response = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        else {
            $response = json_decode($result, true);
        }
        curl_close($ch);
        return $response;
    }
}
