<?php

require_once('./config.php');
require_once('./plugins/Cloudflare.php');
require_once('./plugins/Marzban.php');
require_once('./plugins/BPT.php');

$GLOBALS['Marzban'] = new Marzban();
$GLOBALS['cf'] = new CloudflareAPI(CF_EMAIL, CF_GLOBAL_KEY);
$GLOBALS['settings'] = null;
$GLOBALS['admins'] = $admins;
$GLOBALS['connect'] = $connect;
$GLOBALS['time'] = $time;
$GLOBALS['keyboard'] = $keyboard;
$GLOBALS['marzban_config'] = $marzban_config;

class BPT_handler extends BPT
{
    public function __construct(array $settings)
    {
        parent::__construct($settings);
    }
    public function message($update)
    {
        extract($GLOBALS);

        $from_id =      $update->from->id;
        $chat_type =    $update->chat->type;
        $message_id =   $update->message_id;
        $text =         (isset($update->text)) ? $update->text : null;
        $caption =      (isset($update->caption)) ? $update->caption : null;
        $first_name =   $update->from->first_name;
        if ($chat_type != 'private' || !in_array($from_id, $admins)) {
            return;
        }
        $settings =     $connect->query("SELECT * FROM `settings` LIMIT 1;")->fetch_assoc();
        $user =         $connect->query("SELECT * FROM `user` WHERE `id` = $from_id LIMIT 1;")->fetch_assoc();

        if ($text == '/start' || $text == '🏠') {
            if (empty($user['id'])) {
                $connect->query("INSERT INTO `user` (`id` , `step`) VALUES ($from_id, 'none')");
                $user = $connect->query("SELECT * FROM `user` WHERE `id` = $from_id LIMIT 1")->fetch_assoc();
            }
            $this->send(['text' => "مدیر گرامی؛\nبه پنل بات مدیریت لود بالانس خوش آمدید!📈\n\n❓: این ربات بصورت لحظه ای آیپی های ثبت شده را بررسی و مدیریت میکند ( از طریق مرزبان و کلاود فلیر متصل شده ).\n\n⚠️ نکته: به هیچ عنوان بصورت دستی رکورد هایی که توسط ربات مدیریت میشوند را تغییرات ندهید یا حذف نکنید، قبل آن از ربات آنرا پاک کرده و بعد تغییر دهید.", 'reply_markup' => $this->eKey(['keyboard' => $keyboard['panel']]), 'parse_mode' => 'HTML', 'answer' => null]);
            $this->clearCache($from_id);
            return;
        }
        if ($text == '➕ افزودن رکورد') {
            $this->send(['text' => "🌐 آیپی رکورد / نود را ارسال کنید :", 'reply_markup' => $this->eKey(['keyboard' => $keyboard['back']]), 'parse_mode' => 'HTML', 'answer' => null]);
            $this->saveData($from_id, 'addRecord');
            return;
        }
        if ($text == '🔍 رکورد های موجود') {
            $this->send(['text' => "📋 لیست رکورد های ساخته شده", 'reply_markup' => $this->eKey(['inline' => $this->recordsKey()]), 'parse_mode' => 'HTML', 'answer' => null]);
            return;
        }
        if ($text == '🌐 وضعیت کلاودفلیر') {
            $send =             $this->send(['text' => "⏳", 'parse_mode' => 'HTML', 'answer' => null]);
            $zones =            $cf->listZones();
            if (! is_null($zones['success']) && $zones['success'] == true && isset($zones['result_info']['total_count'])) {
                $total_domains = $zones['result_info']['total_count'];
                $count_records = $connect->query("SELECT * FROM `records`;")->num_rows;
                $count_on_records = $connect->query("SELECT * FROM `records` WHERE `is_online` = 1;")->num_rows;
                $count_off_records = $connect->query("SELECT * FROM `records` WHERE `is_online` = 0;")->num_rows;
                $last_check = Elapsed_time($settings['lastCheck'], 'v2');
                $this->send(['text' => "🌐 تعداد دامنه های شناسایی شده : $total_domains عدد.\n\n➖ تعداد رکورد ها: $count_records عدد\n🟢 آنلاین ها: $count_on_records عدد\n🔴 آفلاین ها: $count_off_records عدد", 'reply_markup' => $this->eKey(['inline' => [[["♾️ آخرین بررسی آیپی ها : $last_check", 'none']]]]), 'parse_mode' => 'HTML', 'answer' => null]);
                $this->deleteMessage(['message_id' => $send['result']['message_id']]);
            } else {
                $this->editMessagetext(['message_id' => $send['result']['message_id'], 'text' => "⚠️ خطا در برقراری ارتباط"]);
            }
            return;
        }
        if ($text == '🎛 وضعیت پنل اصلی') {
            $send =             $this->send(['text' => "⏳", 'parse_mode' => 'HTML', 'answer' => null]);
            $starttime =        microtime(true);
            $status =           $Marzban->full_status();
            $ping =             substr(microtime(true) - $starttime, 0, -11);
            if (! is_null($status['version'])) {
                $mem_used = convert($status['mem_used'], 1);
                $mem_total = convert($status['mem_total'], 1);
                $last_login = Elapsed_time($settings['lastlogin'], 'v2');
                $this->send(['text' => "<b>〰️ اطلاعات و وضعیت پنل مرجع(اصلی) </b>\n\n▫️ ورژن پنل : <code>{$status['version']}</code>\n🚀 پینگ پنل به هاست : <code>$ping</code> ثانیه\n\n⚙️ تعداد هسته (CPU) سرور : <code>{$status['cpu_cores']}</code> هسته\n🧭 مصرف (CPU) سرور : <code>100 / {$status['cpu_usage']} %</code>\n⚖️ کل (Memory) سرور : <code>$mem_total</code>\n🗑 مصرف (Memory) سرور : <code>$mem_used</code>\n\n🟢 تعداد سرویس های فعال(پنل) : <code>{$status['users_active']}</code> از <code>{$status['total_user']}</code> سرویس", 'reply_markup' => $this->eKey(['inline' => [[["♻️ آخرین لوگین ربات : $last_login", 'none']]]]), 'parse_mode' => 'HTML', 'answer' => null]);
                $this->deleteMessage(['message_id' => $send['result']['message_id']]);
            } else {
                $this->editMessagetext(['message_id' => $send['result']['message_id'], 'text' => "⚠️ خطا در برقراری ارتباط با پنل مرجع"]);
            }
            return;
        }
        if ($user['step'] != 'none') { 
            if (isset($update->text)) { # input can be only a text
                if ($user['step'] == 'addRecord') {
                    if (filter_var($text, FILTER_VALIDATE_IP)) {
                        $send = $this->send(['text' => "⏳ در حال بررسی وجود نود ..", 'parse_mode' => 'HTML', 'answer' => null]);
                        $nodes = $Marzban->nodes();
                        $node_id = checkNode($nodes, $text);
                        if (!empty($node_id)) {
                            $this->send(['text' => "➕ دامنه مد نظر خود را کامل ارسال کنید :", 'reply_markup' => $this->eKey(['keyboard' => $keyboard['back']]), 'parse_mode' => 'HTML', 'answer' => null]);
                            $this->saveData($from_id, 'addRecord_domains');
                            $this->saveData($from_id, ['ip' => $text, 'node_id' => $node_id]);
                        } else {
                            $this->send(['text' => "⚠️ نود با این آیپی ادد نشده است یا غیرفعال شده است!", 'parse_mode' => 'HTML', 'answer' => null]);
                        }
                        $this->deleteMessage(['message_id' => $send['result']['message_id']]);
                    } else {
                        $this->send(['text' => "⚠️ فقط یک آیپی معتبر وارد کنید!", 'parse_mode' => 'HTML', 'answer' => null]);
                    }
                    return ;
                }
                if ($user['step'] ==  'addRecord_domains') {
                    $text = preg_replace('#^https?://#', '', $text);
                    if (filter_var($text, FILTER_VALIDATE_DOMAIN, FILTER_FLAG_HOSTNAME)) {
                        $main_domain = $cf->getMainDomain($text);
                        $this->send(['text' => "▫️ <b>Detected domain:</b> $main_domain", 'parse_mode' => 'HTML', 'answer' => null]);
                        $zone_id = $cf->getZoneId($main_domain);
                        if (!empty($zone_id)) {
                            $this->send(['text' => "🔻 مقدار TTL را به ثانیه و بین 60 تا 86400 ثانیه وارد کنید:\n\n💡 برای تنظیم به Auto عدد 1 را وارد کنید.", 'reply_markup' => $this->eKey(['keyboard' => $keyboard['back']]), 'parse_mode' => 'HTML', 'answer' => null]);
                            $this->saveData($from_id, 'addRecord_ttl');
                            $this->saveData($from_id, ['domain' => $text, 'zone_id' => $zone_id]);
                        } else {
                            $this->send(['text' => "⚠️ دامنه در اکانت وجود ندارد!", 'parse_mode' => 'HTML', 'answer' => null]);
                        }
                    } else {
                        $this->send(['text' => "⚠️ فقط یک دامنه معتبر وارد کنید!", 'parse_mode' => 'HTML', 'answer' => null]);
                    }
                    return ;
                }
                if ($user['step'] == 'addRecord_ttl') {
                    if (is_numeric($text)) {
                        if ($text == 1 || ($text >= 60 && $text <= 86400)) {
                            $this->send(['text' => "➖ <b>TTL:</b> $text sec", 'parse_mode' => 'HTML', 'answer' => null]);
                            $datas = $this->getData(['domain', 'zone_id', 'ip', 'node_id'], $from_id);
                            $send = $this->send(['text' => "کمی صبر کنید در حال بررسی اطلاعات ..", 'parse_mode' => 'HTML', 'answer' => null]);
                            $record_ids = $cf->getRecordIdByDomainAndIP($datas['zone_id'], $datas['domain'], $datas['ip']);
                            if (count($record_ids) > 0) {
                                $this->editMessagetext(['message_id' => $send['result']['message_id'], 'text' => "در حال حذف رکورد قبلی با همین آیپی .."]);
                                $cf->deleteRecord($datas['zone_id'], $record_ids[0]);
                                $connect->query("DELETE FROM `records` WHERE `record_id` = '{$record_ids[0]}' LIMIT 1;");
                            }
                            $this->editMessagetext(['message_id' => $send['result']['message_id'], 'text' => "در حال ساخت رکورد جدید .."]);
                            $createRecord = $cf->createRecord($datas['zone_id'], $cf->sendData($datas['domain'], $datas['ip'], 'A', $text));
                            if (isset($createRecord['success']) && $createRecord['success'] == true) {
                                $record_id = $createRecord['result']['id'];
                                $connect->query("INSERT INTO `records` (`ip` , `node_id` , `zone_id` , `record_id` , `domain` , `ttl`) VALUES ('{$datas['ip']}', '{$datas['node_id']}', '{$datas['zone_id']}', '$record_id', '{$datas['domain']}', $text);");
                                $this->send(['text' => "✅ رکورد باموفقیت در CloudFlare ایجاد و در صف بررسی قرار گرفته است.", 'reply_markup' => $this->eKey(['keyboard' => $keyboard['panel']]), 'parse_mode' => 'HTML', 'answer' => null]);
                                $this->clearCache($from_id);
                            } else {
                                $this->send(['text' => "⚠️ خطا در ساخت رکورد!", 'reply_markup' => $this->eKey(['keyboard' => $keyboard['panel']]), 'parse_mode' => 'HTML', 'answer' => null]);
                                $this->clearCache($from_id);
                            }
                            $this->deleteMessage(['message_id' => $send['result']['message_id']]);
                        } else {
                            $this->send(['text' => "⚠️ عدد 1 برای اتوماتیک یا ثانیه از 60 تا 86400 وارد کنید!", 'parse_mode' => 'HTML', 'answer' => null]);
                        }
                    } else {
                        $this->send(['text' => "⚠️ فقط یک عدد لاتین وارد کنید!!", 'parse_mode' => 'HTML', 'answer' => null]);
                    }
                    return ;
                }
            }
        }
        $connect->close();
    }
    public function callback_query($update)
    {
        extract($GLOBALS);
        $data =         $update->data;
        $chat_id =      $update->message->chat->id;
        $first_name =   $update->from->first_name;
        $username =     $update->from->username;
        $from_id =      $update->from->id;
        $message_id =   $update->message->message_id;
        if (!in_array($from_id, $admins)) {
            return;
        }
        $user =         $connect->query("SELECT * FROM `user` WHERE `id` = $from_id LIMIT 1;")->fetch_assoc();
        $settings =     $connect->query("SELECT * FROM `settings` LIMIT 1;")->fetch_assoc();

        if (strstr($data,'serlist_')) 
        {
            $page = str_replace('serlist_', '', $data);
            $this->editMessagetext(['text' => "📋 لیست رکورد های ساخته شده", 'reply_markup' => $this->eKey(['inline' => $this->recordsKey($page)]), 'parse_mode' => 'HTML', 'answer' => null]);
            return ;
        }
        if (strstr($data,'deleteRecord_')) 
        {
            $record_id = str_replace('deleteRecord_', '', $data);
            $record = $connect->query("SELECT * FROM `records` WHERE `record_id` = '$record_id' LIMIT 1;")->fetch_assoc();
            $this->editMessagetext(['text' => "👈🏻 از حذف رکورد ( {$record['ip']} ) برای ( {$record['domain']} ) اطمینان دارید !؟", 'reply_markup' => $this->eKey(['inline' => [[['✅ بله, حذف شود!', 'deleteYESRecord_'.$record_id]],[['🔙 برگشت به صفحه قبلی', 'serlist_1']]]]), 'parse_mode' => 'HTML', 'answer' => null]);
            return ;
        }
        if (strstr($data,'deleteYESRecord_')) 
        {
            $record_id = str_replace('deleteYESRecord_', '', $data);
            $record = $connect->query("SELECT * FROM `records` WHERE `record_id` = '$record_id' LIMIT 1;")->fetch_assoc();
            $this->editMessagetext(['text' => "در حال حذف رکورد ..", 'parse_mode' => 'HTML', 'answer' => null]);
            $cf->deleteRecord($record['zone_id'], $record_id);
            $connect->query("DELETE FROM `records` WHERE `record_id` = '$record_id' LIMIT 1;");
            $this->editMessagetext(['text' => "☑️ باموفقیت از CloudFlare و ربات حذف شد", 'reply_markup' => $this->eKey(['inline' => [[['🔙 برگشت به صفحه قبلی', 'serlist_1']]]]), 'parse_mode' => 'HTML', 'answer' => null]);
            return ;
        }
        $connect->close();
    }
    public function recordsKey(
        $page = 1
    ) {
        global $connect;
        $per_page = 10; # per page show
        $offset = ($page * $per_page) - $per_page;
        $addpage = $page + 1; $menpage = $page - 1;
        $count_all = $connect->query("SELECT * FROM `records`;")->num_rows;
        if ($count_all > 0) {
            $chns = $connect->query("SELECT * FROM `records` ORDER BY `inserttime` ASC LIMIT $per_page OFFSET $offset");
            while ($row = $chns->fetch_assoc())  {
                $mode = ($row['is_online'] == 1) ? '🟢' : '🔴';
                $result[] = [["$mode - {$row['domain']}", 'deleteRecord_'.$row['record_id']]];
            }
            $backpage = ($page > 1) ? 'صفحه قبلی ->' : null; $nextpage = null;
            if (($page * $per_page) < $count_all) {
                $nextpage = '<- صفحه بعدی';
            }
            $result[] = [["{$backpage}", "serlist_{$menpage}"], ["{$nextpage}", "serlist_{$addpage}"]];
        } else {
            $result[] = [["⚠️ هیچ رکوردی ساخته نشده است!", 'none']];
        }
        return $result;
    }
    public function saveData(
        $from_id,
        $data
    ) {
        global $connect, $time;
        if (is_array($data)) {
            $query = null;
            foreach ($data as $step => $value)
                $query .= "INSERT INTO `step` (`id` , `step` , `data` , `inserttime`) VALUES ($from_id, '$step', '$value', $time);" . PHP_EOL;

            $connect->multi_query($query);
        } else
            $connect->query("UPDATE `user` SET `step` = '$data' WHERE `id` = $from_id LIMIT 1;");
    }
    public function getData(
        $data,
        $from_id
    ) {
        global $connect;
        if (is_array($data)) {
            $result = array();
            foreach ($data as $step) {
                $getData = $connect->query("SELECT * FROM `step` WHERE `id` = $from_id AND `step` = '$step' ORDER BY `inserttime` DESC LIMIT 1;")->fetch_assoc();
                $result[$step] = $getData['data'];
            }
        } else {
            $getData = $connect->query("SELECT * FROM `step` WHERE `id` = $from_id AND `step` = '$data' ORDER BY `inserttime` DESC LIMIT 1;")->fetch_assoc();
            $result = $getData['data'];
        }
        return $result;
    }
    public function clearCache(
        $from_id
    ) {
        global $connect;
        $connect->query("DELETE FROM `step` WHERE `id` = $from_id");
        $connect->query("UPDATE `user` SET `step` = 'none' WHERE `id` = $from_id LIMIT 1;");
    }
}
function Elapsed_time($timestamp, $ver = null)
{
    $start_date = new DateTime(date('Y-m-d H:i:s', $timestamp));
    $since_start = $start_date->diff(new DateTime(date('Y-m-d H:i:s', time())));
    if (empty($ver)) {
        $month = (empty($since_start->m) or $since_start->m == 0) ? null : $since_start->m . ' ماه ';
        $day = (empty($since_start->d) or $since_start->d == 0) ? null : $since_start->d . ' روز ';
        $hours = (empty($since_start->h) or $since_start->h == 0) ? null : $since_start->h . ' ساعت ';
        $result = $month . $day . $hours . ' دیگر';
    } else {
        $and = ($timestamp >= time()) ? 'بعد' : 'پیش';
        $day = (empty($since_start->d) or $since_start->d == 0) ? null : $since_start->d . ' روز و ';
        $hour = (empty($since_start->h) or $since_start->h == 0) ? null : $since_start->h . ' ساعت و ';
        $minute = (empty($since_start->i) or $since_start->i == 0) ? null : $since_start->i . ' دقیقه و ';
        $result = $day . $hour . $minute . $since_start->s . ' ثانیه ' . $and;
    }
    return $result;
}
function checkNode(array $nodes, string $ip)
{
    foreach ($nodes as $node) {
        if ($node['address'] == $ip && $node['status'] != 'disabled')
            return $node['id'];
    }
    return null;
}
function convert($size, $round = 2, array $ar = ['بایت', 'کیلوبایت', 'مگابایت', 'گیگابایت', 'ترابایت', 'پتابایت'])
{
    if ($size == 0)
        return '0 مگابایت';
    $round = round($size / pow(1024, ($i = floor(log($size, 1024)))), $round);
    $result = $round . ' ' . $ar[$i];
    return $result;
}
$BPT = new BPT_handler($BPTSettings['handler']);
?>